
import { SlotplanPricetypeListWidget } from './pricetype/SlotplanPricetypeListWidget.js';



export class SlotplanListWidget {
	
	container = null;
	slotplans = null;
	
	ezTpl = null;
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/')}}" class="fa fa-chevron-circle-left"></a>
				<a href="{{appUrl('/masterdata/sales/slotplan/config/')}}" class="fa fa-plus"></a>
			</div>
			
			<h1>Slot plannen</h1>
		</div>
		
		<div id="container-slotplans"></div>
		
		<br/><br/><br/>
		<div id="container-slotplan-pricetypes"></div>
	`;
	
	
	tplSlots = `	
		<div ez-if="slotplans == null">
			Loading...
		</div>
		<div ez-if="slotplans != null">
			<table class="table">
				<thead>
					<tr>
						<th>Naam</th>
						<th>Type</th>
						<th style="width: 175px;">Laatst bewerkt</th>
						<th></th>
					</tr>
				</thead>
				<tbody  ez-for="slotplans" ez-item="sp" class="tbody-slotplans">
					<tr [onclick]="widget.editSlotplan" class="pointer" slotplan-id="{{sp.slotplanId}}">
						<td>{{sp.name}}</td>
						<td>{{sp.defaultSlotType}}</td>
						<td>{{ format_datetime(sp.edited, {dmy: true}) }}</td>
						<td class="actions">
							<a href="javascript:void(0);" class="fa fa-pencil"></a>
						</td>
					</tr>
				</tbody>
					
				<tbody ez-if="slotplans.length == 0">
					<tr>
						<td colspan="6" class="no-results">
							Geen resultaten gevonden
						</td>
					</tr>
				</tbody>
			</table>
			
			<ez-pager></ez-pager>
		</div>
	`;
	

	init(e) {
		this.container = e;
		
		this.render();
		
		this.loadSlotplans();
		
		this.renderPricetypes();
	}

	
	editSlotplan(evt, tr) {
		let artId = tr.getAttribute('slotplan-id');
		
		gotoRoute( '/masterdata/sales/slotplan/config/?id='+artId );
	}


	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		this.renderSlots();
	}
	
	renderSlots() {
		let eztpl = new EzTemplate( '#container-slotplans' );
		eztpl.setObject('widget', this);
		eztpl.setVar('slotplans', this.slotplans);
		eztpl.loadHtml( this.tplSlots );
		eztpl.render();
	}
	
	renderPricetypes() {
		let w = new SlotplanPricetypeListWidget();
		w.init( '#container-slotplan-pricetypes' );
	}
	
	
	loadSlotplans() {
		postUrl( '/service/sales/slot/config.do', {
			a: 'list'
		}).then( async function(e) {
			let json = await e.json();
			
			if (json.error) {
				return showErrorWidget( json );
			}
			
			this.slotplans = json.slotplans;
			
			this.renderSlots();
			
		}.bind(this) );
	}
	
}

